<%-- Copyright (c) 2009, Oracle and/or its affiliates. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbumDBInfo.jsp

    DESCRIPTION
        PhotoAlbumDBInfo.jsp is one component of a JavaServer Pages application
        that demonstrates the use of interMedia Java Classes for Servlets
        and JSPs by implementing a simple photo album application. This
        page is the entry point to the sample. It asks the user to input the 
        database schema username, password and the JDBC connection string.  
        PhotoAlbumBean JavaBean uses the input information to access the database.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.
--%>
<%@ page language="java" %>
<%@ page import="imjspdemo.PhotoAlbumBean" %>
<%@ page import="oracle.ord.im.OrdHttpJspResponseHandler" %>

<jsp:useBean id="album" scope="page" class="imjspdemo.PhotoAlbumBean"/>
<jsp:useBean id="handler" scope="page"
             class="oracle.ord.im.OrdHttpJspResponseHandler"/>

<%-- HTML header --%>
<html lang="EN">
<head>
<title>Oracle Multimedia JavaServer Pages Photo Album Demo</title>
</head>

<body>
<%-- disable browser cache --%>
<%
    response.setHeader( "Pragma", "no-cache" );
    response.setHeader( "Cache-Control", "no-cache" );
    response.setDateHeader( "Expires", 0 );
%>


<%-- Page heading --%>
<table border="0" width="100%">
    <tr>
        <td colspan="2" bgcolor="#f7f7e7" align="center"><font size="+2">
         Oracle Multimedia JavaServer Pages Photo Album Demo</font>
        </td>
    </tr>
</table>

<hr size=1>


<%-- Display error message from a previous attempt --%>
<%
    String errorMessage = request.getParameter( "error" );
    if ( errorMessage != null )
    {
%>
        <p align = "center">
        <img src="images/error_qualifier.png" name="errorIcon" alt="Error:"> <%= errorMessage %>
        </p>
<%
    }
%>

<!--
=============================================================================
For simplicity in demonstrating this feature, this example does not perform
the password management techniques that a deployed system normally uses. In a
production environment, follow the Oracle Database password management
guidelines, and disable any sample accounts. See Oracle Database Security
Guide for password management guidelines and other security recommendations. 
=============================================================================
-->

<%-- empty the stack first --%>
<% album.emptyStack(); %>

<form name="connInfo" action="PhotoAlbum.jsp?page=dbInfo" method="post">
  <table border="0" cellspacing="15" align="center" bgcolor="#f7f7e7">
    <tr>
      <th colspan="2"><font color="#336699">Please provide the following information for the application <br>to connect to a database, retrieve and store images.</font></th>
    </tr>
    <tr>
      <td>Schema:</td>
      <td><input type="text" name="username"  maxlength="30" value= <%= request.getParameter("ousername")==null?"":request.getParameter("ousername")%> ></td>
    </tr>   
    <tr>
      <td>Password:</td>
      <td><input type="password" name="password"  size="18" maxlength="30"></td>
    </tr>
    <tr>
      <td>JDBC Connect String:<br><font size="-2"></td>
      <td><input type="text" name="connString" value= <%= request.getParameter("oconnString")==null?"":request.getParameter("oconnString") %>>
      <br><font size="-1">(See README.txt file for explanation)</font></td>
    </tr>
    <tr>
      <td align="right" colspan="2"><input type="submit" value="Submit"></td>
    </tr>
  </table>
</form>

</body>
</html>
